package Document::CMS::Document;

use strict;
use Data::Dumper;
use MT::Util qw( offset_time_list );
use Time::Piece;
use Document::Util qw(array_search);
use Encode;

sub list {
  my $app = shift;
  my %params = $app->param_hash();

  return $app->return_to_dashboard( redirect => 1 )
    unless $app->can_do( 'blog_administer' );

  my $tmpl = 'cms/document_list.tmpl';
  return $app->build_page($tmpl, \%params);
}

sub download {
  my $app = shift;
  my $q = $app->param;

  return $app->return_to_dashboard( redirect => 1 )
    unless $app->can_do( 'blog_administer' );

  my $plugin = $app->component('Document');
  my $site_iter = $app->model('website')->load_iter();
  if ( $q->param('template_list') ) {
    my $line = '';
    my $csv_name = $plugin->t('[_1]_TemplateList.csv', today());
    send_header($csv_name);
    send_tmpl_csv_header();
    # global templates
    my $global_iter = $app->model('template')->load_iter({blog_id => 0}, {sort_by => 'type', order => 'descend'});
    my %tmpls = ();
    while ( my $tmpl = $global_iter->() ) {
      my $tmpl_type = $tmpl->type;
      next if array_search($tmpl_type, &invisible_templates());
      $tmpl_type = &check_type($tmpl_type);
      next if $q->param('no_system') && $tmpl_type eq 'system';
      next if $q->param('no_widget') && $tmpl_type =~ /widget/;
      my $line = join(',', (0, $plugin->translate('System'), '', '', $tmpl->id, $tmpl->name, $tmpl_type, $tmpl->outfile, $tmpl->identifier, $tmpl->linked_file));
      $tmpls{$tmpl_type} = [] unless defined $tmpls{$tmpl_type};
      push @{$tmpls{$tmpl_type}}, $line;
    }
    &print_each_type_lines(\%tmpls);
    my @site_pre_columns = ();
    while ( my $site = $site_iter->() ) {
      @site_pre_columns = ($site->id, $site->name);
      my $blog_iter = $app->model('blog')->load_iter({parent_id => $site->id}, { sort_by => 'id', order => 'ascend'});
      my @blog_pre_columns = ();
      my $print_csv = sub {
        my ($blog_id) = @_;
        my $tmpl_iter = $app->model('template')->load_iter({blog_id => $blog_id},{sort_by => 'type', order => 'descend'});
        my @tmpl_pre_columns = ();
        my %tmpls = ();
        while ( my $tmpl = $tmpl_iter->() ) {
          my $tmpl_type = $tmpl->type;
          next if array_search($tmpl_type, &invisible_templates());
          $tmpl_type = &check_type($tmpl_type);
          next if $q->param('no_system') && $tmpl_type eq 'system';
          next if $q->param('no_widget') && $tmpl_type =~ /widget/;
          @tmpl_pre_columns = ($tmpl->id, $tmpl->name, $tmpl_type);
          my @line_head = (@site_pre_columns, @blog_pre_columns, @tmpl_pre_columns);
          my @line = (@line_head, $tmpl->outfile, $tmpl->identifier, $tmpl->linked_file);
          $tmpls{$tmpl_type} = [] unless defined $tmpls{$tmpl_type};

          unless ( $tmpl->type eq 'individual' || $tmpl->type eq 'archive' ) {
            my $line = join(',', @line);
            push @{$tmpls{$tmpl_type}}, $line;
            next;
          }
          my @lines = ();
          my $map_iter = $app->model('templatemap')->load_iter({template_id => $tmpl->id},{sort_by => 'id', order => 'descend'});
          my $i = 0;
          while ( my $map = $map_iter->() ) {
            if ( $i++ == 0 ) {
              $line[7] = $map->file_template;
              push @lines, join(',', @line, $map->archive_type,);
            } else {
              push @lines, join(',', (@line_head, $map->file_template, '','', $map->archive_type));
            }
          }
          next unless @lines;
          my $line = join("\r\n", @lines);
          push @{$tmpls{$tmpl_type}}, $line;
        }
        &print_each_type_lines(\%tmpls);
      };
      $print_csv->($site->id);
      while ( my $blog = $blog_iter->() ) {
        @blog_pre_columns = ($blog->id, $blog->name);
        $print_csv->($blog->id);
      }
    }
  }
  if ( $q->param('customfields_list') ) {
    my $line = '';
    my $csv_name = $plugin->t('[_1]_CustomFieldsList.csv', today());
    send_header($csv_name);
    send_cf_csv_header();
    my @site_pre_columns = ();
    while ( my $site = $site_iter->() ) {
      @site_pre_columns = ($site->id, $site->name);
      my $blog_iter = $app->model('blog')->load_iter({parent_id => $site->id}, { sort_by => 'id', order => 'ascend'});
      my @blog_pre_columns = ();
      my $print_csv = sub {
        my ($blog_id) = @_;
        my $field_iter = $app->model('field')->load_iter({blog_id => $blog_id},{sort_by => 'obj_type', order => 'descend'});
        my @fields = $app->model('field')->load({blog_id => $blog_id},{sort_by => 'obj_type', order => 'descend'});
        my @fields_pre_columns = ();
        my %fields = ();
        while ( my $f = $field_iter->() ) {
          my $field_obj_type = $f->obj_type;
          @fields_pre_columns = (@site_pre_columns, @blog_pre_columns, $f->id, $f->obj_type, '"'.$f->name.'"', '"'.$f->description.'"', $f->type, '"'.$f->options.'"', '"'.$f->default.'"', $f->required, $f->basename, $f->tag);
          my $line = join(',', @fields_pre_columns);
          push @{$fields{$field_obj_type}}, $line;
        }
        &print_each_type_lines(\%fields);
      };
      $print_csv->($site->id);
      while ( my $blog = $blog_iter->() ) {
        @blog_pre_columns = ($blog->id, $blog->name);
        $print_csv->($blog->id);
      }
    }
  }
  if ( $q->param('category_list') ) {
    my $line = '';
    my $csv_name = $plugin->t('[_1]_CategoryList.csv', today());
    send_header($csv_name);
    send_category_csv_header();
    my @site_pre_columns = ();
    while ( my $site = $site_iter->() ) {
      @site_pre_columns = ($site->id, $site->name);
      my $blog_iter = $app->model('blog')->load_iter({parent_id => $site->id}, { sort_by => 'id', order => 'ascend'});
      my @blog_pre_columns = ('','');
      my $print_csv = sub {
        my ($blog_id) = @_;
        my @top_cats = $app->model('category')->top_level_categories($blog_id);
        return unless @top_cats;
        my @cats_pre_columns = ();
        my %cats = ();
        foreach my $c ( @top_cats ) {
          @cats_pre_columns = (@site_pre_columns, @blog_pre_columns, $c->id, '"'.$c->label.'"', '','','', '"'.$c->label.'"', '"'.$c->basename.'"', '"'.$c->description.'"');
          my $line = join(',', @cats_pre_columns);
          $cats{$c->id} = [] unless ref $cats{$c->id};
          push @{$cats{$c->id}}, $line;
          my @sub_child = $c->children_categories;
          foreach my $child ( @sub_child ) {
            @cats_pre_columns = (@site_pre_columns, @blog_pre_columns, $child->id, '', $child->label, '','', '"'.$child->label.'"', '"'.$child->basename.'"', '"'.$child->description.'"');
            my $line = join(',', @cats_pre_columns);
            push @{$cats{$c->id}}, $line;
            my @gsub_child = $child->children_categories;
            foreach my $gchild ( @gsub_child ) {
              @cats_pre_columns = (@site_pre_columns, @blog_pre_columns, $gchild->id, '', '', $gchild->id, '', '"'.$gchild->label.'"', '"'.$gchild->basename.'"', '"'.$gchild->description.'"');
              my $line = join(',', @cats_pre_columns);
              push @{$cats{$c->id}}, $line;
              my @ggsub_child = $gchild->children_categories;
              foreach my $ggchild ( @ggsub_child ) {
                @cats_pre_columns = (@site_pre_columns, @blog_pre_columns, $ggchild->id, '', '', '', $ggchild->label, '"'.$ggchild->label.'"', '"'.$ggchild->basename.'"', '"'.$ggchild->description.'"');
                my $line = join(',', @cats_pre_columns);
                push @{$cats{$c->id}}, $line;
              }
            }
          }
        }
        &print_each_type_lines(\%cats);
      };
      $print_csv->($site->id);
      while ( my $blog = $blog_iter->() ) {
        @blog_pre_columns = ($blog->id, $blog->name);
        $print_csv->($blog->id);
      }
    }
  }
  exit(1);
}

sub send_header {
  my $filename = shift;
  print "Content-Type: text/csv\n";
  print "Content-Disposition: attachment; filename=$filename\n\n";
}

sub send_tmpl_csv_header {
  print join(',', qw(website_id website_name blog_id blog_name template_id template_name type outfile/map identifier linked_file archive_type)) ."\r\n";
}

sub send_cf_csv_header {
  print join(',', qw(website_id website_name blog_id blog_name field_id field_obj_type field_name field_description field_type field_options field_default field_required field_basename field_tag)) ."\r\n";
}

sub send_category_csv_header {
  print join(',', qw(website_id website_name blog_id blog_name category_id 1 2 3 4 category_label category_basename category_description)) ."\r\n";
}

sub redirect {
  my $app = shift;
  my $mode = shift;
  my %args = @_;
  return $app->redirect(
    $app->uri(mode => $mode, args => \%args));
}

sub today {
  my $t = localtime;
  join('', split('-', $t->ymd)) .join('', split(':', $t->hms));
}

sub invisible_templates {
  qw(comment_listing);
}

sub check_type {
  my $tmpl_type = shift;
  # global system templates
  if ( array_search($tmpl_type, qw(profile_error register_form new_password login_form profile_edit_form profile_view new_password_reset_form register_confirmation profile_feed) ) ) {
      $tmpl_type = 'system';
  }
  # website or blog
  if ( array_search($tmpl_type, qw(comment_preview search_results popup_image comment_response dynamic_error comment_listing) ) ) {
      $tmpl_type = 'system';
  }
  $tmpl_type;
}
sub print_each_type_lines {
  my $hash = shift;
  die "Invalid args 1. Args should be hash reference." unless ref($hash) eq 'HASH';
  for my $line_type ( sort keys %$hash ) {
    my $line = join("\r\n", @{$hash->{$line_type}});
    print MT::I18N::encode_text($line."\r\n", 'utf-8', 'sjis');
  }
}
1;
