package FormattedTextOnContentType::App;

use strict;

use MT;
use FormattedText::App;


sub _hdlr_template_param_edit_content_data {
    my ( $cb, $app, $param, $tmpl ) = @_;
    
    _load_formatted_text_to_param( 'formatted_texts', @_ );
}

sub _load_formatted_text_to_param {
    my ( $key, $cb, $app, $param, $tmpl ) = @_;

    my $perms = $app->permissions;
    my $user  = $app->user;

    my @formatted_texts
        = $app->model('formatted_text')->load( { blog_id => $app->blog->id },
        { sort => 'id', direction => 'descend' } );
    $param->{$key} = [ grep { FormattedText::App::can_view_formatted_text( $perms, $_, $user ) }
            @formatted_texts ];
}

1;