package FormattedTextOnContentType::Plugin;

use strict;
use warnings;

use MT;
use Data::Dumper;
use base qw(MT::Plugin);

use vars qw( $VERSION $OLD_VERSION );
$VERSION = '0.8.00';
$OLD_VERSION = 0;

use FormattedTextOnContentType::L10N;
use FormattedText::App;

my $plugin = FormattedTextOnContentType::Plugin->new({
  id => 'FormattedTextOnContentType',
  key => __PACKAGE__,
  name => 'FormattedTextOnContentType',
  l10n_class => 'FormattedTextOnContentType::L10N',
  description => '<__trans phrase="Add ContentType to stylized Code." />',
  doc_link => 'https://www.cherry-pick.jp/',
  author_name => "cherry-pick Inc.",
  author_link => 'https://www.cherry-pick.jp/',
  settings => new MT::PluginSettings([
  ]),
  version => $VERSION,
});

sub init_registry {
  my ($plugin) = @_;
  my $cfg = MT->config;
  my $pkg = '$FormattedTextOnContentType::FormattedTextOnContentType::';
  $plugin->registry({
    applications => {
      cms => {
        callbacks => {
          'template_param.edit_content_data' => $pkg. 'App::_hdlr_template_param_edit_content_data',
        },
        menus => {
          'entry:manage_formatted_text' => {
            display => 0,
          },
          'manage_formatted_text' => {
            label => 'Boilerplate',
            order => 450,
            display => 1,
          },
          'manage_formatted_text:list' => {
            label => 'Boilerplate',
            order => 450,
            mode => 'list',
            args => {
              _type => 'formatted_text',
            },
            condition => sub {
              require FormattedText::App;
              my $app = MT->instance;

              return 0 unless FormattedText::App::is_enabled($app);

              # System Administrator
              return 1 if $app->user->is_superuser;

              # Blog context
              if ( $app->blog ) {
                  my $perm = $app->permissions;
                  return 0 unless $perm;
                  return $perm->can_do(
                      'access_to_formatted_text_list');
              }

              # System context
              my $iter = $app->model('permission')->load_iter(
                  {   author_id => $app->user->id,
                      blog_id   => { not => 0 }
                  }
              );

              while ( my $p = $iter->() ) {
                  return 1
                      if $p->can_do(
                          'access_to_formatted_text_list');
              }

              return 0;
            },
            view => ['website', 'blog'],
          },
        },
      },
    },
  });
}

sub instance {
  $plugin;
}

1;
