package ContentTypeEx::Util;

use strict;

use base 'Exporter';
our @EXPORT_OK = qw(
  _dump
  _log
  _debug
  _dt
  _decode_utf8
  _encode_utf8
  plugin
  _t
  license_manager
  unable_plugin
  enable_plugin
  trim
  empty
  array_search
  get_plugin_config
  do_redirect
);

use MT;
use MT::Mail;
use MT::Log;
use MT::App::CMS;
use MT::Util qw(format_ts is_valid_email encode_html);
use Data::Dumper;

sub plugin {
  MT->component('ContentTypeEx');
}

sub _dump {
  use Data::Dumper;
  Dumper @_;
}

sub _log {
  my ($msg, $is_blog, $meta) = @_;
  my $params = {
    category => 'info',
    level    => MT::Log::INFO(),
    message  => $msg,
  };
  $params->{class} = 'blog' if defined $is_blog;
  $params->{meta} = _dump $meta if defined $meta;
  MT->instance->log($params);
}

sub _debug {
  MT::log($_[0]);
}

sub _dt {
  my @caller = caller;
  MT::log($caller[1].'::'.$caller[2]);
}

sub _decode_utf8 {
  Encode::is_utf8($_[0]) ? $_[0] : Encode::decode_utf8($_[0]);
}

sub _encode_utf8 {
  Encode::is_utf8($_[0]) ? Encode::encode_utf8($_[0]) : $_[0];
}

sub _t {
  plugin->translate(@_);
}

sub license_manager {
  my $plugin = plugin();
  no strict;
  my $local_active_env_name = $plugin->name .'LocalActivation';
  my $lm = CherryPick::LicenseManager->new({
    plugin          => $plugin,
    plugin_key      => $plugin->id,
    register_url    => 'https://mtlmc.cherry-pick.jp/api/licenses/register',
    confirm_url     => 'https://mtlmc.cherry-pick.jp/api/licenses/register',
    confirm_interval => 14,
    trial_days => 60,
    local_activation => MT->config->$local_active_env_name ? 1 : 0,
  }) || return $plugin->error(CherryPick::LicenseManager->errstr);
  $lm;
}

sub unable_plugin {
  !enable_plugin();
}

sub enable_plugin {
  my $lm = license_manager();
  return 1 if $lm->is_registered;
  return 1 unless $lm->is_expired;
  0;
}

sub trim {
  $_ = $_[0];
  return unless $_;
  s!^\s*!!;
  s!\s*$!!;
  $_;
}

sub empty {
  my $val = shift;
  return 1 unless defined $val;
  return 1 unless $val;
  0;
}

sub array_search {
  my ($arr, $needle) = @_;
  return undef unless ref $arr eq 'ARRAY';
  foreach ( @$arr ) {
    return 1 if $_ eq $needle;
  }
  -1;
}
sub get_plugin_config {
  my ($blog_id) = @_;
  my $scope = 'blog:' .$blog_id;
  my $cfg = plugin->get_config_hash($scope);
  my $sys_cfg = plugin->get_config_hash();
  map {
    $cfg->{$_} = $sys_cfg->{$_}
  } grep {
    defined $sys_cfg->{$_}
  } qw/work_dir/;
  $cfg;
}


sub do_redirect {
  my ($app, $url) = @_;
  my $q = $app->param;
  my $qr = ref $q;
  if ( $ENV{MOD_PERL} ) {
      $app->{apache}->header_out( Location => $url );
      $app->response_code( Apache::Constants::REDIRECT() );
      $app->send_http_header;
  }
  elsif ( $qr =~ /::PSGI/i ) {
    $app->redirect($url);
  }
  else {
    $app->print(
      $q->redirect( -uri => $url, %{ $app->{cgi_headers} } ) );
  }
  1;
}

1;
