package ContentTypeEx::Plugin;

use strict;
use warnings;

use MT;
use base qw(MT::Plugin);

use vars qw( $VERSION $OLD_VERSION $SCHEMA_VERSION );
$VERSION = '0.8.00 alpha';
$OLD_VERSION = 0;

use ContentTypeEx::L10N;
use ContentTypeEx::Util qw(license_manager enable_plugin);

my $plugin = ContentTypeEx::Plugin->new({
  id => 'ContentTypeEx',
  key => __PACKAGE__,
  name => 'ContentTypeEx',
  l10n_class => 'ContentTypeEx::L10N',
  description => '<__trans phrase="Support your Content Type." />',
  doc_link => 'https://www.cherry-pick.jp/mt-plugins/',
  author_name => "cherry-pick Inc.",
  author_link => 'https://www.cherry-pick.jp/',
  #system_config_template => \&ContentTypeEx::CMS::Config::system_config,
  #blog_config_template => \&ContentTypeEx::CMS::Config::blog_config,
  settings => new MT::PluginSettings([
    ['work_dir', { Scope => 'blog' }],
  ]),
  schema_version => $SCHEMA_VERSION,
  version => $VERSION,
});

sub init_registry {
  my ($plugin) = @_;
  my $cfg = MT->config;
  my $pkg = '$ContentTypeEx::ContentTypeEx::';
  $plugin->registry({
    callbacks => {
      post_init => $pkg .'MT::post_init',
    },
  });
}

sub instance {
  $plugin;
}

1;
