package CherryPick::Util;

use strict;
use warnings;

use base 'Exporter';
our @EXPORT_OK = qw(array_search);


sub array_search {
  my ($needle, $haystack) = @_;
  my $type = ref $haystack;
  die 'Invalid second arg. It must be ARRAY or HASH reference.'
    unless $type eq 'ARRAY' || $type eq 'HASH';
  
  if ( lc $type eq 'array' ) {
    my $count = scalar @$haystack;
    for (my $i=0; $i<$count; $i++) {
      return 1 if $haystack->[$i] eq $needle;
    }
  }
  elsif ( lc $type eq 'hash' ) {
    foreach (keys %$haystack) {
      return $_ if $haystack->{$_} eq $needle;
    }
  }
  return undef;
}
1;