# $Id$

package CherryPick::LicenseManager::CMS;

use strict;

sub handle_register_licensekey {
    my $lm = shift;
    my $app = shift;
    my $q = $app->param;
    
    # Check license manager.
    die $app->translate('License manager error.') if !$lm && ref($lm) ne 'CherryPick::LicenseManager';
    
    # Register the license key.
    my $status = $lm->register_license({
        licensekey  => $q->param('licensekey'),
        email       => $q->param('email'),
    });

    my $plugin_config_url = $app->uri(mode => 'cfg_plugins', args => {blog_id => 0, plugin_licensekey_registered => $status});
    $app->redirect($plugin_config_url);
}

sub handle_template_param_cfg_plugin {
    my ($lm, $cb, $app, $param, $tmpl) = @_;
    my $q = $app->param;
    
    # Check license manager.
    die $app->translate('License manager error.') if !$lm && ref($lm) ne 'CherryPick::LicenseManager';
    
    # Show message only for the parameter defined.
    $param->{plugin_licensekey_registered} = $q->param('plugin_licensekey_registered');
    return unless $param->{plugin_licensekey_registered};
    
    # Message.
    $param->{plugin_licnsekey_last_message} = $lm->last_message || return;
    $lm->last_message(''); # Reset.
    
    # Insert registered message as status message.
    my $setvarblock_nodes = $tmpl->getElementsByTagName('setvarblock');
    foreach my $n (@$setvarblock_nodes) {
        # Look up the system_msg node.
        if($n->getAttribute('name') eq 'system_msg') {
            # Insert the new system_msg.
            my $system_msg_node = $tmpl->createElement('setvarblock', {name => 'system_msg', append => 1});
            
            # Success, notice or error.
            $system_msg_node->innerHTML(q{
                <mt:if name="plugin_licensekey_registered" eq="error">
                    <mt:setvar name="statusclass" value="error">
                <mt:else>
                    <mt:setvar name="statusclass" value="success">
                </mt:if>
                <mtapp:statusmsg
                    id="plugin-licensekey-registered"
                    class="$statusclass">
                    <mt:var name="plugin_licnsekey_last_message">
                </mtapp:statusmsg>
            });
            
            $tmpl->insertAfter($system_msg_node, $n);
            last;
        }
    }
}

1;