package CategorySetFields::CMS;

use strict;

use MT;
use Data::Dumper;
use CustomFields::App::CMS;

sub on_init_request {

  1;
}

sub init_app {
  my ($cb, $app) = @_;
  no strict 'refs';
  no warnings;
  *CustomFields::App::CMS::edit_category_param = sub { _handle('CategorySetFields::CMS', 'edit_category_param', @_); };
}

sub _handle {
    my $pkg = shift;
    my $method = shift;
    {
      no strict 'refs';
      my $code = \&{ $pkg .'::' .$method };
      $code->(@_);
    }
}


sub edit_category_param {
    my ( $cb, $app, $param, $tmpl ) = @_;

    my $category_id = $param->{id} || 0;
    my $category = MT->model('category')->load($category_id);
    #return 1 if !$category || $category->category_set_id;
    return 1 if !$category;

    # Add <mtapp:fields> after description
    CustomFields::App::CMS::add_app_fields( $cb, $app, $param, $tmpl, 'description', 'insertAfter' );

    # Display our reorder widget
    CustomFields::App::CMS::add_reorder_widget( $cb, $app, $param, $tmpl );

    my $obj_type
        = $param->{object_type} eq 'category' ? 'entry'
        : $param->{object_type} eq 'folder'   ? 'page'
        :                                       undef;
    return 1 unless defined $obj_type;

    # Show the list of Custom Fields for entry/page
    my $blog_ids = [0];
    if ( my $blog_id = $app->param('blog_id') ) {
        push @$blog_ids, $blog_id;
    }
    my $class = $app->model('field');
    my @fields
        = $class->load( { blog_id => $blog_ids, obj_type => $obj_type }, );

    my %existing_fields;
    if ( my $id = $app->param('id') ) {
        my $type      = $app->param('_type');
        my $cat_class = $app->model($type);
        if ($cat_class) {
            my $cat = $cat_class->load($id);
            if ( my $fields = $cat->show_fields ) {
                $existing_fields{$_} = 1 foreach split /,/, $fields;
            }
        }
    }

    my $list = [];
    foreach (@fields) {
        my $values = $_->get_values;
        $values->{selected} = 1 if exists $existing_fields{ $_->id };
        push @$list, $values;
    }
    $param->{show_fields_list} = $list
      unless $category->category_set_id;

    my ($place)
        = grep { $_->attributes->{name} eq 'action_buttons' }
        @{ $tmpl->getElementsByTagName('setvarblock') };
    return 1 unless $place;
    my $include = $tmpl->createElement( 'include',
        { name => 'category_fields.tmpl' } );
    $tmpl->insertBefore( $include, $place );
}

1;