package CategorySetFields::Plugin;

use strict;
use warnings;

use MT;
use base qw(MT::Plugin);

use vars qw( $VERSION $OLD_VERSION $SCHEMA_VERSION );
$VERSION = '0.8.00';
$OLD_VERSION = 0;

use CategorySetFields::L10N;

my $plugin = CategorySetFields::Plugin->new({
  id => 'CategorySetFields',
  key => __PACKAGE__,
  name => 'CategorySetFields',
  l10n_class => 'CategorySetFields::L10N',
  description => '<__trans phrase="Add CustomField to CategorySets." />',
  doc_link => 'https://www.cherry-pick.jp/',
  author_name => "cherry-pick Inc.",
  author_link => 'https://www.cherry-pick.jp/',
  settings => new MT::PluginSettings([
  ]),
  version => $VERSION,
});

sub init_registry {
  my ($plugin) = @_;
  my $cfg = MT->config;
  my $pkg = '$CategorySetFields::CategorySetFields::';
  $plugin->registry({
    callbacks => {
      'MT::App::CMS::init_request' => [
        {
          priority => 1,
          code => $pkg .'CMS::init_app',
        },
      ],
    },
  });
}

sub instance {
  $plugin;
}

1;
